Ext.data.JsonP.sol_common_Map({"tagname":"class","name":"sol.common.Map","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.Map.js","href":"lib_sol.common.Map.html#sol-common-Map"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.02.001"],"eloix":true,"eloas":true,"elojc":true,"requires":["sol.common.ObjectUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"asAdmin","tagname":"cfg","owner":"sol.common.Map","id":"cfg-asAdmin","meta":{}},{"name":"mapId","tagname":"cfg","owner":"sol.common.Map","id":"cfg-mapId","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.Map","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"forEachRow","tagname":"method","owner":"sol.common.Map","id":"method-forEachRow","meta":{}},{"name":"getKwlKey","tagname":"method","owner":"sol.common.Map","id":"method-getKwlKey","meta":{}},{"name":"getNumValue","tagname":"method","owner":"sol.common.Map","id":"method-getNumValue","meta":{}},{"name":"getValue","tagname":"method","owner":"sol.common.Map","id":"method-getValue","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.Map","id":"method-initialize","meta":{"private":true}},{"name":"keyAndValueExist","tagname":"method","owner":"sol.common.Map","id":"method-keyAndValueExist","meta":{}},{"name":"read","tagname":"method","owner":"sol.common.Map","id":"method-read","meta":{}},{"name":"setNumValue","tagname":"method","owner":"sol.common.Map","id":"method-setNumValue","meta":{}},{"name":"setValue","tagname":"method","owner":"sol.common.Map","id":"method-setValue","meta":{}},{"name":"setValues","tagname":"method","owner":"sol.common.Map","id":"method-setValues","meta":{}},{"name":"write","tagname":"method","owner":"sol.common.Map","id":"method-write","meta":{}}],"code_type":"ext_define","id":"class-sol.common.Map","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":["sol.common.SordMap","sol.common.WfMap"],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.Map</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/sol.common.SordMap' rel='sol.common.SordMap' class='docClass'>sol.common.SordMap</a></div><div class='dependency'><a href='#!/api/sol.common.WfMap' rel='sol.common.WfMap' class='docClass'>sol.common.WfMap</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.Map.html#sol-common-Map' target='_blank'>lib_sol.common.Map.js</a></div></pre><div class='doc-contents'><p>Base class that represents map data</p>\n      <p class='version-tag'>Version: <b>1.02.001</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-asAdmin' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-cfg-asAdmin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-cfg-asAdmin' class='name expandable'>asAdmin</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>If <code>true</code>, the copy process will run in administrator context</p>\n</div><div class='long'><p>If <code>true</code>, the copy process will run in administrator context</p>\n</div></div></div><div id='cfg-mapId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-cfg-mapId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-cfg-mapId' class='name expandable'>mapId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Map ID</p>\n</div><div class='long'><p>Map ID</p>\n</div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID</p>\n</div><div class='long'><p>Object ID</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-forEachRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-forEachRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-forEachRow' class='name expandable'>forEachRow</a>( <span class='pre'>endOfTableIndicatorColumnName, func, ctx</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Iterates over a table. ...</div><div class='long'><p>Iterates over a table.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>endOfTableIndicatorColumnName</span> : String<div class='sub-desc'><p>Key name of a column to check wether the line exists</p>\n</div></li><li><span class='pre'>func</span> : Function<div class='sub-desc'><p>Callback function for the iteration</p>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'><p>Execution context</p>\n</div></li></ul></div></div></div><div id='method-getKwlKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-getKwlKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-getKwlKey' class='name expandable'>getKwlKey</a>( <span class='pre'>key, separator</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the keyword list key ...</div><div class='long'><p>Returns the keyword list key</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>String</p>\n</div></li><li><span class='pre'>separator</span> : String<div class='sub-desc'><p>Separator</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getNumValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-getNumValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-getNumValue' class='name expandable'>getNumValue</a>( <span class='pre'>key</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a number value ...</div><div class='long'><p>Returns a number value</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : type<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>key</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Gets a value from the map by a given key. ...</div><div class='long'><p>Gets a value from the map by a given key.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-keyAndValueExist' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-keyAndValueExist' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-keyAndValueExist' class='name expandable'>keyAndValueExist</a>( <span class='pre'>key</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a key and value exists ...</div><div class='long'><p>Checks wether a key and value exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Key</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-read' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-read' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-read' class='name expandable'>read</a>( <span class='pre'>keynames</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads all map entries of an ELO object from the ix map database. ...</div><div class='long'><p>Reads all map entries of an ELO object from the ix map database.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>keynames</span> : String[]<div class='sub-desc'><p>Keynames keys to be read (optional)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setNumValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-setNumValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-setNumValue' class='name expandable'>setNumValue</a>( <span class='pre'>key, value</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a number value ...</div><div class='long'><p>Sets a number value</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-setValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-setValue' class='name expandable'>setValue</a>( <span class='pre'>key, value</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a map value of an ELO object. ...</div><div class='long'><p>Sets a map value of an ELO object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-setValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-setValues' class='name expandable'>setValues</a>( <span class='pre'>map</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Set values ...</div><div class='long'><p>Set values</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>Map</p>\n</div></li></ul></div></div></div><div id='method-write' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Map'>sol.common.Map</span><br/><a href='source/lib_sol.common.Map.html#sol-common-Map-method-write' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Map-method-write' class='name expandable'>write</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes the new map entries of an ELO object to the ix map database. ...</div><div class='long'><p>Writes the new map entries of an ELO object to the ix map database.</p>\n</div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true}});